<?php

namespace App\Modules\Blog\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PostResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'status' => $this->status,
            'slug' => $this->slug,
            'publish_date' => $this->publish_date,
            'page_header' => $this->page_header,
            'page_description' => $this->page_description,
            'page_og_image' => $this->page_og_image,
            'author' => $this->author,
            'content' => $this->content_body, // WYSIWYG JSON
            'tags' => $this->tags, // Вызываем кастомный метод formatTags()
            'category' => $this->category, // Загружаем категорию
        ];
    }

    /**
     * Метод для форматирования тегов в ['en' => [], 'ru' => []]
     */
//    private function formatTags(): array
//    {
//        $tags = $this->tags->map(function ($tag) {
//            $name = json_decode($tag->name, true); // Декодируем JSON
//            return [
//                'id' => $tag->id,
//                'name' => $name, // ['en' => 'Tech', 'ru' => 'Технологии']
//            ];
//        });
//
//        // Преобразуем в ['en' => [], 'ru' => []]
//        $formattedTags = ['en' => [], 'ru' => []];
//
//        foreach ($tags as $tag) {
//            $formattedTags['en'][] = ['id' => $tag['id'], 'name' => $tag['name']['en'] ?? null];
//            $formattedTags['ru'][] = ['id' => $tag['id'], 'name' => $tag['name']['ru'] ?? null];
//        }
//
//        return $formattedTags;
//    }
}
