<?php

namespace App\Exceptions;

use Illuminate\Auth\Access\AuthorizationException;
use Symfony\Component\HttpKernel\Exception\HttpException;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Throwable;

class Handlers
{
    public function __invoke(Request $request, Throwable $exception): JsonResponse
    {
        if ($exception instanceof AuthorizationException) {
            return response()->json([
                'success' => false,
                'message' => 'You do not have permission to perform this action.',
                'error_code' => 'forbidden',
            ], 403);
        }

        if ($exception instanceof HttpException) {
            return response()->json([
                'success' => false,
                'message' => $exception->getMessage() ?: 'An error occurred.',
                'status_code' => $exception->getStatusCode(),
            ], $exception->getStatusCode());
        }

        return response()->json([
            'success' => false,
            'message' => 'Server error.',
            'error_code' => 'server_error',
        ], 500);
    }
}
