<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Auth\Access\AuthorizationException;
use Illuminate\Http\JsonResponse;

class CustomAuthorizationMiddleware
{
    public function handle($request, Closure $next)
    {
        try {
            return $next($request);
        } catch (AuthorizationException $exception) {
            return response()->json([
                'success' => false,
                'message' => 'You do not have permission to perform this action.',
                'error_code' => 'forbidden',
            ], 403);
        }
    }
}
