<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\App;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next)
    {
        // Получаем язык из заголовка `Accept-Language`
        $locale = $request->header('Accept-Language');

        // Доступные языки (они должны быть в `/lang/`)
        $availableLocales = Config::get('app.available_locales', ['en', 'ru']);

        // Проверяем, что язык есть в списке доступных, иначе ставим `en`
        if (in_array($locale, $availableLocales)) {
            App::setLocale($locale);
        } else {
            App::setLocale('en'); // По умолчанию английский
        }

        return $next($request);
    }
}
