<?php

namespace App\Modules\Blog\Policies;

use App\Models\User;

class BlogPolicy
{
    public function create(User $user): bool
    {
        \Log::info('PostPolicy::create called for user ID: ' . $user->id);
        return $user->hasPermission('blog', 'create');
    }

    public function read(User $user): bool
    {
        return $user->hasPermission('blog', 'read');
    }

    public function update(User $user): bool
    {
        return $user->hasPermission('blog', 'update');
    }

    public function delete(User $user): bool
    {
        return $user->hasPermission('blog', 'delete');
    }
}
