<?php

namespace App\Modules\Blog\Policies;

use App\Models\User;

class CategoryPolicy
{
    public function create(User $user): bool
    {
        return $user->hasPermission('blog', 'category', 'create');
    }

    public function read(User $user): bool
    {
        return $user->hasPermission('blog', 'category', 'read');
    }

    public function update(User $user): bool
    {
        return $user->hasPermission('blog', 'category', 'update');
    }

    public function delete(User $user): bool
    {
        return $user->hasPermission('blog', 'category', 'delete');
    }
}
