<?php

namespace App\Modules\Blog\Policies;

use App\Models\User;

class PostPolicy
{
    public function create(User $user): bool
    {
        return $user->hasPermission('blog', 'post', 'create');
    }

    public function read(User $user): bool
    {
        return $user->hasPermission('blog', 'post', 'read');
    }

    public function update(User $user): bool
    {
        return $user->hasPermission('blog', 'post', 'update');
    }

    public function delete(User $user): bool
    {
        return $user->hasPermission('blog', 'post', 'delete');
    }
}
