<?php


namespace App\Modules\Blog\Policies;

use App\Models\User;

class TagPolicy
{
    public function create(User $user): bool
    {
        return $user->hasPermission('blog', 'tag', 'create');
    }

    public function read(User $user): bool
    {
        return $user->hasPermission('blog', 'tag', 'read');
    }

    public function update(User $user): bool
    {
        return $user->hasPermission('blog', 'tag', 'update');
    }

    public function delete(User $user): bool
    {
        return $user->hasPermission('blog', 'tag', 'delete');
    }
}

