<?php

use App\Modules\Blog\Http\Controllers\CategoriesController;
use App\Modules\Blog\Http\Controllers\PostsController;
use App\Modules\Blog\Http\Controllers\TagsController;
use Illuminate\Support\Facades\Route;



Route::middleware('auth:sanctum')->prefix('v1/blogs')->group(function () {
    // Tags
    Route::get('/tags', [TagsController::class, 'getTags']); // Get list of tags
    Route::post('/tags', [TagsController::class, 'createTag']); // Create tag
    Route::delete('/tags/{id}', [TagsController::class, 'deleteTag']); // Delete tag

    // Categories
    Route::get('/categories', [CategoriesController::class, 'getCategories']); // Get list of categories
    Route::post('/categories', [CategoriesController::class, 'createCategory']); // Create category
    Route::delete('/categories/{id}', [CategoriesController::class, 'deleteCategory']); // Delete category

    // Posts
    Route::get('/posts', [PostsController::class, 'getPosts']); // Get list of posts
    Route::get('/posts/{id}', [PostsController::class, 'getPost']); // Get post
    Route::post('/posts', [PostsController::class, 'createPost']); // Create post
    Route::put('/posts/', [PostsController::class, 'updatePost']); // Update post
    Route::put('/posts/content', [PostsController::class, 'updatePostContent']); // Update post
    Route::delete('/posts/{id}', [PostsController::class, 'deletePost']); // Delete post
    Route::get('/posts/category/{category_id}', [PostsController::class, 'getPostsByCategory']); // Get post by category
    Route::get('/posts/tag/{tag_id}', [PostsController::class, 'getPostsByTag']); // Get post by tags
});


Route::prefix('v1/blogs/b2c')->group(function () {
    Route::get('/posts', [PostsController::class, 'getPostsB2c']);
    Route::get('/posts/{slug}', [PostsController::class, 'getPostB2c']);
    Route::get('/posts/category/{category_id}', [PostsController::class, 'getPostsByCategory']);
    Route::get('/posts/tag/{tag_id}', [PostsController::class, 'getPostsByTag']);
    Route::get('/categories', [CategoriesController::class, 'getCategoriesB2c']);
});


