<?php

namespace App\Modules\Finance\Models\Monolith;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class Club extends Model
{
    use HasFactory;

    protected $connection = 'external_db';

    protected $fillable = [
        'active',
        'name',
        'address',
        'number_of_courts',
        'description',
        'logo',
        'logo_og',
        'language',
        'currency_id',
        'organization_name',
        'country_id',
        'license',
        'bank_name',
        'iban',
        'swift_code',
        'email',
        'lat',
        'lng',
        'domain',
    ];

    protected $casts = [
        'passport'            => 'array',
        'trade_licence'       => 'array',
        'regulation_of_power' => 'array',
        'photos'              => 'array'
    ];

    public function locations()
    {
        return $this->hasMany(ClubLocation::class);
    }

//    public function currency(): BelongsTo
//    {
//        return $this->belongsTo(Currency::class);
//    }
}
