<?php

namespace App\Modules\Management\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Modules\Management\Models\Monolith\Club;
use App\Modules\Management\Models\Monolith\ClubCourt;
use App\Modules\Management\Models\Monolith\ClubInvite;
use App\Modules\Management\Models\Monolith\ClubLocation;
use App\Modules\Management\Models\Monolith\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;


class ClubController extends Controller
{
    public function createClub222(Request $request)
    {
        $request->validate([
            'club_name' => 'required|string',
            'address' => 'required|string',
            'number_of_courts' => 'required|integer',
            'description' => 'required|string',
            'lat' => 'required|string',
            'lng' => 'required|string',
            'domain' => 'required|string',
            'location_name' => 'required|string',
            'location_description' => 'required|string',
            'phone' => 'required|string',
            'email' => 'required|string',
            'location_address' => 'required|string',
            'slug' => 'required|string',
            'worktime_start' => 'required|string',
            'worktime_end' => 'required|string',
            'user_name' => 'required|string',
            'user_surname' => 'required|string',
            'user_email' => 'required|string',
            'user_phone' => 'required|string',
        ]);

        DB::beginTransaction(); // Начинаем транзакцию

        try {
            // Создание клуба
            $club = Club::create([
                'name' => $request->club_name,
                'address' => $request->address,
                'number_of_courts' => $request->number_of_courts,
                'description' => $request->description,
                'lat' => $request->lat,
                'lng' => $request->lng,
                'domain' => $request->domain,
                'email' => $request->email,
                'language' => 'en',
                'currency_id' => 2,
                'country_id' => 226,
            ]);

            // Создание локации клуба
            $location = ClubLocation::create([
                'club_id' => $club->id,
                'name' => $request->location_name,
                'description' => $request->location_description,
                'phone' => $request->phone,
                'email' => $request->email,
                'address' => $request->location_address,
                'slug' => $request->slug,
                'latitude' => $request->lat,
                'longitude' => $request->lng,
                'photos' => '[]',
                'worktime_start' => $request->worktime_start,
                'worktime_end' => $request->worktime_end,
                'timezone' => 4
            ]);

            // Создание кортов
            $courts = [];
            for ($i = 0; $i < $request->number_of_courts; $i++) {
                $courts[] = [
                    'club_location_id' => $location->id,
                    'name' => 'Court ' . ($i + 1),
                    'price' => 0,
                    'worktime_start' => $request->worktime_start,
                    'worktime_end' => $request->worktime_end,
                    'is_active' => 1,
                    'capacity' => 4,
                    'is_shuffled' => 0,
                    'court_place_type' => 'outdoor',
                ];
            }
            ClubCourt::insert($courts); // Массовая вставка

            // Создание пользователя
            $user_password = Str::random(16);
            $club_user = User::create([
                'name' => $request->user_name,
                'surname' => $request->user_surname,
                'email' => $request->user_email,
                'password' => Hash::make($user_password),
                'phone_number' => $request->user_phone,
                'registered' => 1,
            ]);

            // Назначение роли пользователю
            DB::connection('external_db')->table('user_roles')->insert([
                'user_id' => $club_user->id,
                'role_id' => 2
            ]);

            // Привязка пользователя к клубу
            DB::connection('external_db')->table('club_user')->insert([
                'club_id' => $club->id,
                'user_club_role' => 'Admin',
                'user_id' => $club_user->id
            ]);

            // Создание приглашения в клуб
            $club_invite = ClubInvite::create([
                'hash' => md5($club->id . $club_user->id . time()),
                'club_id' => $club->id,
                'admin_id' => $club_user->id,
                'email' => $club_user->email,
                'status' => ClubInvite::STATUS_NEW,
            ]);



            // Подготовка данных для ответа
            $result = [
                'club' => $club,
                'location' => $location,
                'courts' => ClubCourt::where('club_location_id', $location->id)->get(),
                'user' => $club_user,
                'club_invite' => $club_invite,
                'password' => $user_password,
            ];

            //return response()->success('Club created successfully', $result);

        } catch (\Exception $e) {
            DB::rollBack(); // Откатываем все изменения в случае ошибки
            return response()->error('Error creating club', [$e->getMessage()], 402);
        }
        // Если все выполнено успешно, фиксируем изменения
        DB::commit();
        return response()->success('Club created successfully', $result);
    }

    public function createClub(Request $request)
    {
        $request->validate([
            // Club info
            'club_name' => 'required|string',
            'description' => 'required|string',
            'domain' => 'required|string',
            'email' => 'required|string',
            'currency_id' => 'required|integer',
            'country_id' => 'required|integer',

            // Club owner
            'owner_email' => 'required|string',
            'owner_name' => 'required|string',
            'owner_surname' => 'required|string',
            'owner_phone' => 'required|string',
        ]);

        $club = Club::create([
            'name' => $request->club_name,
            'description' => $request->description,
            'domain' => $request->domain,
            'email' => $request->email,
            'language' => 'en',
            'currency_id' => $request->currency_id,
            'country_id' => $request->country_id,
        ]);

        if (!$club) {
            return response()->error('Error creating club', [], 422);
        }

        // Создание пользователя
        $user_password = Str::random(16);
        $club_user = User::create([
            'name' => $request->owner_name,
            'surname' => $request->owner_surname,
            'email' => $request->owner_email,
            'password' => Hash::make($user_password),
            'phone_number' => $request->owner_phone,
            'registered' => 1,
        ]);

        if (!$club_user) {
            return response()->error('Error creating club user', [], 422);
        }

        // Назначение роли пользователю
        DB::connection('external_db')->table('user_roles')->insert([
            'user_id' => $club_user->id,
            'role_id' => 2
        ]);

        // Привязка пользователя к клубу
        DB::connection('external_db')->table('club_user')->insert([
            'club_id' => $club->id,
            'user_club_role' => 'Admin',
            'user_id' => $club_user->id
        ]);

        // Создание приглашения в клуб
        $club_invite = ClubInvite::create([
            'hash' => md5($club->id . $club_user->id . time()),
            'club_id' => $club->id,
            'admin_id' => $club_user->id,
            'email' => $club_user->email,
            'status' => ClubInvite::STATUS_NEW,
        ]);

        $result = [
            'club' => $club,
            'user' => $club_user,
            'password' => $user_password,
        ];

        return response()->success('Club created successfully', $result);
    }


    public function createLocation(Request $request)
    {
        $request->validate([
            'club_id' => 'required|integer',
            'address' => 'required|string',
            'number_of_courts' => 'required|integer',
            'description' => 'required|string',
            'lat' => 'required|string',
            'lng' => 'required|string',
            'domain' => 'required|string',
            'location_name' => 'required|string',
            'location_description' => 'required|string',
            'phone' => 'required|string',
            'email' => 'required|string',
            'location_address' => 'required|string',
            'slug' => 'required|string',
            'worktime_start' => 'required|string',
            'worktime_end' => 'required|string',
            'user_name' => 'required|string',
            'user_surname' => 'required|string',
            'user_email' => 'required|string',
            'user_phone' => 'required|string',
        ]);
        $club_id = $request->input('club_id');

        $club = Club::find($club_id);

        if (!$club) {
            return response()->errorNotFound('Club not found');
        }
        DB::beginTransaction(); // Начинаем транзакцию

        try {
            // Создание локации клуба
            $location = ClubLocation::create([
                'club_id' => $club_id,
                'name' => $request->location_name,
                'description' => $request->location_description,
                'phone' => $request->phone,
                'email' => $request->email,
                'address' => $request->location_address,
                'slug' => $request->slug,
                'latitude' => $request->lat,
                'longitude' => $request->lng,
                'photos' => '[]',
                'worktime_start' => $request->worktime_start,
                'worktime_end' => $request->worktime_end,
                'timezone' => 4
            ]);

            // Создание кортов
            $courts = [];
            for ($i = 0; $i < $request->number_of_courts; $i++) {
                $courts[] = [
                    'club_location_id' => $location->id,
                    'name' => 'Court ' . ($i + 1),
                    'price' => 0,
                    'worktime_start' => $request->worktime_start,
                    'worktime_end' => $request->worktime_end,
                    'is_active' => 1,
                    'capacity' => 4,
                    'is_shuffled' => 0,
                    'court_place_type' => 'outdoor',
                ];
            }
            ClubCourt::insert($courts); // Массовая вставка

            // Создание пользователя
            $user_password = Str::random(16);
            $club_user = User::create([
                'name' => $request->user_name,
                'surname' => $request->user_surname,
                'email' => $request->user_email,
                'password' => Hash::make($user_password),
                'phone_number' => $request->user_phone,
                'registered' => 1,
            ]);

            // Назначение роли пользователю
            DB::connection('external_db')->table('user_roles')->insert([
                'user_id' => $club_user->id,
                'role_id' => 2
            ]);

            // Привязка пользователя к клубу
            DB::connection('external_db')->table('club_user')->insert([
                'club_id' => $club_id,
                'user_club_role' => 'Admin',
                'user_id' => $club_user->id
            ]);

            // Создание приглашения в клуб
            $club_invite = ClubInvite::create([
                'hash' => md5($club_id . $club_user->id . time()),
                'club_id' => $club_id,
                'admin_id' => $club_user->id,
                'email' => $club_user->email,
                'status' => ClubInvite::STATUS_NEW,
            ]);



            // Подготовка данных для ответа
            $result = [
                'club' => $club,
                'location' => $location,
                'courts' => ClubCourt::where('club_location_id', $location->id)->get(),
                'user' => $club_user,
                'club_invite' => $club_invite,
                'password' => $user_password,
            ];

            //return response()->success('Club created successfully', $result);

        } catch (\Exception $e) {
            DB::rollBack(); // Откатываем все изменения в случае ошибки
            return response()->error('Error creating club', [$e->getMessage()], 402);
        }
        // Если все выполнено успешно, фиксируем изменения
        DB::commit();
        return response()->success('Club created successfully', $result);
    }

    public function createLocation222(Request $request)
    {
        $request->validate([
            'club_id' => 'required|integer',
            'club_name' => 'required|string',
            'address' => 'required|string',
            'number_of_courts' => 'required|integer',
            'description' => 'required|string',
            'lat' => 'required|string',
            'lng' => 'required|string',
            'domain' => 'required|string',
            'location_name' => 'required|string',
            'location_description' => 'required|string',
            'phone' => 'required|string',
            'email' => 'required|string',
            'location_address' => 'required|string',
            'slug' => 'required|string',
            'worktime_start' => 'required|string',
            'worktime_end' => 'required|string',
            'user_name' => 'required|string',
            'user_surname' => 'required|string',
            'user_email' => 'required|string',
            'user_phone' => 'required|string',
        ]);
        $club_id = $request->input('club_id');

        $club = Club::find($club_id);

        if (!$club) {
            return response()->errorNotFound('Club not found');
        }

        // Создание локации клуба
        $location = ClubLocation::create([
            'club_id' => $club_id,
            'name' => $request->location_name,
            'description' => $request->location_description,
            'phone' => $request->phone,
            'email' => $request->email,
            'address' => $request->location_address,
            'slug' => $request->slug,
            'latitude' => $request->lat,
            'longitude' => $request->lng,
            'photos' => array(),
            'worktime_start' => $request->worktime_start,
            'worktime_end' => $request->worktime_end,
            'timezone' => 4
        ]);


        return response()->success('Club created successfully', $result);
    }




}
