<?php

namespace App\Modules\Management\Models\Monolith;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ClubCourt extends Model
{
    use HasFactory;

    protected $connection = 'external_db';

    public const CAPACITY_TWO = 2;
    public const CAPACITY_FOUR = 4;

    /**
     * Court types
     */

    public const COURT_PLACE_TYPE_ANY = 'any';
    public const COURT_PLACE_TYPE_INDOOR = 'indoor';
    public const COURT_PLACE_TYPE_OUTDOOR = 'outdoor';

    public $timestamps = false;

    protected $casts = [
        'is_active'   => 'bool',
        'is_shuffled' => 'bool',
    ];

    protected $fillable = [
        'club_location_id',
        'name',
        'price',
        'worktime_start',
        'worktime_end',
        'game_type',
        'is_active',
        'capacity',
        'is_shuffled',
        'court_place_type'
    ];

    protected $hidden = [
        'playtomic_court_uuid',
    ];

}
