<?php

namespace App\Modules\Management\Models\Monolith;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use Exception;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Http\JsonResponse;
use Illuminate\Notifications\Notifiable;
use Illuminate\Support\Facades\Auth;
use Laravel\Sanctum\HasApiTokens;
use Laravel\Sanctum\PersonalAccessToken;
use ReflectionClass;


class User extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;

    protected $connection = 'external_db';

    public const ROLE_COACH = 'coach';
    public const ROLE_MANAGER = 'manager';
    public const SPECIALIZATION_LESSONS = 'lessons';
    public const SPECIALIZATION_TOURNAMENTS = 'tournaments';
    public const SPECIALIZATION_TRAININGS = 'trainings';
    public const SPECIALIZATION_ASSESSMENTS = 'assessments';
    public const PLAYERS_MALE = 'male';
    public const PLAYERS_FEMALE = 'female';

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'surname',
        'country_id',
        'birth_date',
        'sex',
        'category_id',
        'client_level_id',
        'specialization',
        'players',
        'email',
        'password',
        'phone_number',
        'registered',
        'terms_red_at',
        'email_verified_at',
        'description',
        'is_visible_on_b2c',
        'main_photo_id'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'email_verified_at',
        'created_at',
        'updated_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'specialization' => 'json',
        'players' => 'json',
    ];

    public static function boot()
    {
        parent::boot();

        static::created(function ($item) {
            $item->color = rand(0, 360);
            $item->save();
        });

//        static::saving(function ($user) {
//            if (!empty($user->phone_number)) {
//                $user->phone_number = (new PhoneFormatUtil($user->phone_number))->generalFormat();
//            }
//        });
    }

    public function generateToken(string $userId): JsonResponse
    {
        $user = User::query()->where('id', $userId);

        $accessToken = $user->createToken('Access token', ['*'])->accessToken;

        return response()->json([
            'access_token' => $accessToken,
        ]);
    }


}
