<?php

namespace App\Modules\User\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Foundation\Http\FormRequest;

class UsersController extends Controller
{
    public function profile()
    {
        $user_id = auth()->id();
        $user = User::with('permissions')->find($user_id);

        if (!$user) {
            return response()->errorNotFound('User not found');
        }

        // Группируем разрешения по модулям и сущностям
        $permissionsGrouped = $user->permissions
            ->groupBy(['module', 'entity'])
            ->map(function ($entities) {
                return $entities->mapWithKeys(function ($actions, $entity) {
                    return [$entity => $actions->pluck('action')->toArray()];
                });
            });

        $responseData = [
            'id' => $user->id,
            'name' => $user->name,
            'surname' => $user->surname,
            'email' => $user->email,
            'color' => $user->color,
            'permissions' => $permissionsGrouped,
            'avatar' => NULL
        ];

        return response()->success('User profile', $responseData);
    }
}
