<?php

namespace App\Providers;

use App\Modules\Blog\Models\Category;
use App\Modules\Blog\Models\Tag;
use App\Modules\Blog\Policies\CategoryPolicy;
use App\Modules\Blog\Policies\TagPolicy;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

// Подключаем policy
use App\Modules\Blog\Models\Post;
use App\Modules\Blog\Policies\PostPolicy;

class AuthServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        // Blog module
        Gate::policy(Post::class, PostPolicy::class);
        Gate::policy(Category::class, CategoryPolicy::class);
        Gate::policy(Tag::class, TagPolicy::class);
    }
}
