<?php

use App\Http\Controllers\ImageController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\User;
use App\Modules\Finance\Models\Monolith\Client;

Route::get('/user', function (Request $request) {
    return $request->user();
})->middleware('auth:sanctum');




Route::prefix('v1/admins/image')->group(function () {
    Route::post('/upload', [ImageController::class, 'upload']); // Загрузка изображения
    Route::get('/', [ImageController::class, 'index']); // Список изображений
    Route::get('/{id}', [ImageController::class, 'show']); // Получение изображения
    Route::delete('/remove/{id}', [ImageController::class, 'removeImage']); // Скачивание изображения
});

Route::get('/test', function () {
    return Client::all();
});

Route::get('/bgg', function () {
    return 'HI' ;
});
