<?php

namespace App\Modules\Finance\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LocationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'club_id' => $this->club_id,
            'name' => $this->name,
            'custom_name' => $this->custom_name,
            'phone' => $this->phone,
            'description' => $this->description,
            'custom_logo' => NULL,
            'address' => $this->address,
            'slug' => $this->slug,
            'latitude' => $this->latitude,
            'longitude' => $this->longitude,
            'worktime_start' => $this->worktime_start,
            'worktime_end' => $this->worktime_end,
            'timezone' => $this->timezone,
        ];
    }
}
