<?php

use App\Modules\User\Http\Controllers\Auth\AuthController;
use App\Modules\User\Http\Controllers\UsersController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;


Route::prefix('v1/admins/auth/')->group(function () {
    Route::post('/login', [AuthController::class, 'login']); // Login (не требует авторизации)
});

Route::middleware('auth:sanctum')->prefix('v1/admins/auth')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']); // Logout (требует авторизации)
    Route::get('/test', [AuthController::class, 'test']); // Test endpoint (требует авторизации)

    Route::get('/profile', [UsersController::class, 'profile']); // User profile (требует авторизации)
});

Route::middleware('auth:sanctum')->prefix('v1/admins/user')->group(function () {
    Route::get('/profile', [UsersController::class, 'profile']); // User profile (требует авторизации)
});




