<?php

namespace App\Providers;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\File;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Response;

class ResponseMacroServiceProvider extends ServiceProvider
{
    public function register(): void
    {
        //
    }

    public function boot(): void
    {
        info('ResponseMacroServiceProvider booting...');
        $self = $this;

        Response::macro('success', function ($message = null, array|object $data = null) use ($self) {
            $dataArray = [
                'success'  => true,
                'hasPages' => false,
                'data'     => $data,
                'message'  => __($message),
            ];

            // Проверяем, является ли переданный объект пагинированной коллекцией
            if ($data instanceof \Illuminate\Http\Resources\Json\AnonymousResourceCollection && method_exists($data->resource, 'hasPages')) {
                $paginator = $data->resource; // Получаем оригинальную пагинированную коллекцию

                $dataArray['hasPages'] = true;
                $dataArray['pagination'] = [
                    'current_page' => $paginator->currentPage(),
                    'pages_count'  => $paginator->lastPage(),
                    'from'         => $paginator->firstItem(),
                    'to'           => $paginator->lastItem(),
                    'per_page'     => (int)$paginator->perPage(),
                    'total'        => $paginator->total(),
                ];
                $dataArray['data'] = $data->collection; // Конвертируем `ResourceCollection` в обычный массив
            } elseif (is_object($data) && method_exists($data, 'hasPages')) {
                $dataArray['hasPages'] = true;
                $dataArray['pagination'] = [
                    'current_page' => $data->currentPage(),
                    'pages_count'  => $data->lastPage(),
                    'from'         => $data->firstItem(),
                    'to'           => $data->lastItem(),
                    'per_page'     => (int)$data->perPage(),
                    'total'        => $data->total(),
                ];
                $dataArray['data'] = $data->items();
            } elseif (is_array($data) && count($data) === 2 && isset($data['pagination'])) {
                $dataArray['hasPages'] = true;
                $dataArray['pagination'] = $data['pagination'];
                $dataArray['data'] = $data[0];
            }

            return Response::json($dataArray, 200);
        });

        Response::macro('error', function ($message = null, array|object $data = null, int $code = 500) use ($self) {
            return Response::json([
                'success' => false,
                'data'    => $data,
                'message' => __($message),
            ], $code);
        });

        Response::macro('errorNotFound', function ($message = null, array|object $data = null) use ($self) {
            return Response::json([
                'success' => false,
                'data'    => $data,
                'message' => __($message),
            ], 404);
        });
    }



}
